import { StyleSheet } from "react-native";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";

export const billingInfoStyle = StyleSheet.create({
    text: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(16),
        color: "#2C2C2C",
        marginTop: dpr(16),
    },
    otherAddressCont: {
        borderWidth: 1,
        borderColor: "#DFDFDF",
        borderRadius: 6,
        padding: dpr(15),
        flexDirection: "row",
        justifyContent: "center",
    },
    addAddressBtn: {
        marginTop: dpr(20),
        borderStyle: "dashed",
        borderColor: "#2C2C2C",
    },
    grandTotal: {
        borderRadius: 6,
        borderWidth: 1,
        borderColor: "#DFDFDF",
        paddingVertical: dpr(20),
        position: "absolute",
        bottom: dpr(100),
        width: dpr("wf") - dpr(20) * 2,
        marginHorizontal: dpr(20),
    },
    checkoutBtn: {
        bottom: dpr(10),
        left: dpr(20),
        position: "absolute",
    },
    checkoutBtnBg: (shippingAddress) => ({
        backgroundColor: shippingAddress ? '#FCCA19' : '#F1F1F1',
    }),
    grandText: {
        textAlign: "center",
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(18),
        color: "#8B8B8B",
    },
    priceText: {
        textAlign: "center",
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(33),
        color: "#2C2C2C",
    },
    mt: {
        marginTop: 0,
    },
});
